/**
 * Gibt eine GPT-Antwort zurück
 * @customfunction
 * @param {string} prompt
 * @returns {string}
 */
async function GPT(prompt) {
  const apiKey = localStorage.getItem("openai_api_key");
  const res = await fetch("https://api.openai.com/v1/chat/completions", {
    method: "POST",
    headers: {
      "Authorization": `Bearer ${apiKey}`,
      "Content-Type": "application/json"
    },
    body: JSON.stringify({
      model: "gpt-4",
      messages: [{ role: "user", content: prompt }],
      temperature: 0.5
    })
  });

  const data = await res.json();
  return data.choices[0].message.content;
}
